/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InfoDisplayer
extends JFrame {
    static final String[] EASELIST_1 = new String[]{"Polynomial", "Exponential", "Fractional", "Circular", "Sine", "Hyp Sine", "Tangent", "Hyp Tangent", "Bounce", "Elastic"};
    static final String[] EASELIST_2 = new String[]{"Ease In", "Ease Out", "Ease In Out", "Ease Out In"};
    InnerAnimationPanel innerAnimPanel;
    InnerGraphPanel innerGraphPanel;
    static JTextArea errorLogArea;
    static volatile JLabel currentCoordLabel;
    JLabel firstCoordLabel;
    JLabel secondCoordLabel;
    static volatile int currentMouseCoordX;
    static volatile int currentMouseCoordY;
    static int coord1X;
    static int coord1Y;
    static int coord2X;
    static int coord2Y;
    ValueObtainer obtainer;
    InfoDisplayer displayer;
    AutoEaser autoBot;

    public void setupBot() {
        try {
            this.autoBot = new AutoEaser();
        }
        catch (AWTException aWTException) {
            InfoDisplayer.appendErrorMessage("failed to create automator, automation is not recommended");
        }
    }

    public void buildFrame() {
        this.displayer = this;
        this.setTitle("Ease Automator");
        JPanel jPanel = new JPanel();
        this.applyKeystroke(jPanel);
        JPanel jPanel2 = new JPanel();
        this.innerAnimPanel = new InnerAnimationPanel();
        JPanel jPanel3 = new JPanel();
        this.innerGraphPanel = new InnerGraphPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Ease Type");
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder("Actions");
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder("Values to Adjust");
        TitledBorder titledBorder4 = BorderFactory.createTitledBorder("Mouse Trackings");
        TitledBorder titledBorder5 = BorderFactory.createTitledBorder("Animation Panel");
        TitledBorder titledBorder6 = BorderFactory.createTitledBorder("Graph Panel");
        jPanel4.setBorder(titledBorder);
        jPanel5.setBorder(titledBorder2);
        jPanel6.setBorder(titledBorder3);
        jPanel8.setBorder(titledBorder4);
        jPanel2.setBorder(titledBorder5);
        jPanel3.setBorder(titledBorder6);
        final JComboBox<String> jComboBox = new JComboBox<String>(EASELIST_1);
        final JComboBox<String> jComboBox2 = new JComboBox<String>(EASELIST_2);
        jComboBox.setMaximumSize(jComboBox.getPreferredSize());
        jComboBox2.setMaximumSize(jComboBox2.getPreferredSize());
        JButton jButton = new JButton("Swap Positions");
        JButton jButton2 = new JButton("Automate");
        JButton jButton3 = new JButton("Test the Ease");
        JButton jButton4 = new JButton("Restore Graph");
        JLabel jLabel = new JLabel("Start pos:");
        JLabel jLabel2 = new JLabel("End pos:");
        JLabel jLabel3 = new JLabel("Duration: (60FPS)");
        final JLabel jLabel4 = new JLabel("Exponent:");
        final JLabel jLabel5 = new JLabel("");
        currentCoordLabel = new JLabel("Current Cursor Coordinates: (0, 0)");
        this.firstCoordLabel = new JLabel("Coordinate 1: (0, 0)");
        this.secondCoordLabel = new JLabel("Coordinate 2: (0, 0)");
        final JTextField jTextField = new JTextField(10);
        final JTextField jTextField2 = new JTextField(10);
        final JTextField jTextField3 = new JTextField(10);
        final HashMap<Integer, JLabel> hashMap = new HashMap<Integer, JLabel>();
        final HashMap<Integer, JLabel> hashMap2 = new HashMap<Integer, JLabel>();
        hashMap.put(1, new JLabel("0.001"));
        hashMap.put(10000, new JLabel("10.0"));
        hashMap2.put(0, new JLabel("0.0"));
        hashMap2.put(0, new JLabel("0.0"));
        final JSlider jSlider = new JSlider(1, 10000);
        jSlider.setLabelTable(new Hashtable(hashMap));
        jSlider.setPaintLabels(true);
        final JSlider jSlider2 = new JSlider(0, 0);
        jSlider2.setLabelTable(new Hashtable(hashMap2));
        jSlider2.setPaintLabels(true);
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(5.0, 0.001, 10.0, 0.01);
        final JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        final SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(5.0, 0.001, 10.0, 0.01);
        final JSpinner jSpinner2 = new JSpinner(spinnerNumberModel2);
        jTextField.setMaximumSize(jTextField.getPreferredSize());
        jTextField2.setMaximumSize(jTextField2.getPreferredSize());
        jTextField3.setMaximumSize(jTextField3.getPreferredSize());
        jSlider.setMaximumSize(jSlider.getPreferredSize());
        jSlider2.setMaximumSize(jSlider2.getPreferredSize());
        jSpinner.setMaximumSize(jSpinner.getPreferredSize());
        jSpinner2.setMaximumSize(jSpinner2.getPreferredSize());
        final JCheckBox jCheckBox = new JCheckBox("Adjust for Z Dist");
        final JCheckBox jCheckBox2 = new JCheckBox("Enable Motion Trails");
        this.obtainer = new ValueObtainer(){

            @Override
            public double obtainStartPos(int n) {
                switch (n) {
                    case 1: {
                        return InfoDisplayer.returnValidDouble(jTextField.getText());
                    }
                    case 2: {
                        return InfoDisplayer.this.innerAnimPanel.getStart();
                    }
                    case 3: {
                        return InfoDisplayer.this.innerGraphPanel.returnStart();
                    }
                }
                return InfoDisplayer.returnValidDouble(jTextField.getText());
            }

            @Override
            public double obtainEndPos(int n) {
                switch (n) {
                    case 1: {
                        return InfoDisplayer.returnValidDouble(jTextField2.getText());
                    }
                    case 2: {
                        return InfoDisplayer.this.innerAnimPanel.getEnd();
                    }
                    case 3: {
                        return InfoDisplayer.this.innerGraphPanel.returnEnd();
                    }
                }
                return InfoDisplayer.returnValidDouble(jTextField.getText());
            }

            @Override
            public double obtainDuration(int n) {
                switch (n) {
                    case 1: {
                        return InfoDisplayer.returnValidDouble(jTextField3.getText());
                    }
                    case 2: {
                        return InfoDisplayer.returnValidDouble(jTextField3.getText()) * 1000.0 / 60.0;
                    }
                    case 3: {
                        return InfoDisplayer.this.innerGraphPanel.returnLengthWithOffset();
                    }
                }
                return InfoDisplayer.returnValidDouble(jTextField3.getText());
            }

            @Override
            public double obtainMiscValue1() {
                return (double)jSlider.getValue() / 1000.0;
            }

            @Override
            public double obtainMiscValue2() {
                return (double)jSlider2.getValue() / 1000.0;
            }

            @Override
            public String obtainEaseType1() {
                return jComboBox.getSelectedItem().toString();
            }

            @Override
            public String obtainEaseType2() {
                return jComboBox2.getSelectedItem().toString();
            }
        };
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                hashMap.clear();
                hashMap2.clear();
                String string = null;
                String string2 = null;
                String string3 = jComboBox.getSelectedItem().toString();
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (string3.equals(EASELIST_1[0])) {
                    string = "Exponent";
                    n = 10000;
                    n2 = 1;
                } else if (string3.equals(EASELIST_1[1])) {
                    string = "Base";
                    n = 10000;
                    n2 = 1001;
                } else if (string3.equals(EASELIST_1[2])) {
                    string = "Frac Constant";
                    n = 999;
                    n2 = 1;
                } else if (string3.equals(EASELIST_1[3])) {
                    string = "Exponent";
                    n = 10000;
                    n2 = 1001;
                } else if (string3.equals(EASELIST_1[4])) {
                    n = 0;
                    n2 = 0;
                } else if (string3.equals(EASELIST_1[5])) {
                    string = "Power";
                    n = 10000;
                    n2 = 1001;
                } else if (string3.equals(EASELIST_1[6])) {
                    string = "Power";
                    n = 10000;
                    n2 = 1;
                } else if (string3.equals(EASELIST_1[7])) {
                    string = "Power";
                    n = 1000;
                    n2 = 1;
                } else if (string3.equals(EASELIST_1[8])) {
                    string = "Bounciness";
                    n = 500;
                    n2 = 1;
                } else {
                    string = "Damp Amplitude";
                    string2 = "Period Scale";
                    n = 10000;
                    n2 = 2000;
                    n3 = 1000;
                    n4 = 10;
                }
                jSlider.setMaximum(n);
                jSlider.setMinimum(n2);
                jSlider2.setMaximum(n3);
                jSlider2.setMinimum(n4);
                spinnerNumberModel.setMaximum(Double.valueOf((double)n / 1000.0));
                spinnerNumberModel.setMinimum(Double.valueOf((double)n2 / 1000.0));
                jSpinner.setModel(spinnerNumberModel);
                spinnerNumberModel2.setMaximum(Double.valueOf((double)n3 / 1000.0));
                spinnerNumberModel2.setMinimum(Double.valueOf((double)n4 / 1000.0));
                jSpinner2.setModel(spinnerNumberModel2);
                hashMap.put(n2, new JLabel(String.valueOf((double)n2 / 1000.0)));
                hashMap.put(n, new JLabel(String.valueOf((double)n / 1000.0)));
                jSlider.setLabelTable(new Hashtable(hashMap));
                hashMap2.put(n4, new JLabel(String.valueOf((double)n4 / 1000.0)));
                hashMap2.put(n3, new JLabel(String.valueOf((double)n3 / 1000.0)));
                jSlider2.setLabelTable(new Hashtable(hashMap2));
                if (string != null) {
                    string = string.concat(":");
                    jLabel4.setText(string);
                    jLabel4.setEnabled(true);
                    jSpinner.setEnabled(true);
                    jSlider.setEnabled(true);
                } else {
                    string = "";
                    jLabel4.setText(string);
                    jLabel4.setEnabled(false);
                    jSpinner.setEnabled(false);
                    jSlider.setEnabled(false);
                }
                if (string2 != null) {
                    string2 = string2.concat(":");
                    jLabel5.setText(string2);
                    jLabel5.setVisible(true);
                    jSpinner2.setVisible(true);
                    jSlider2.setVisible(true);
                } else {
                    jLabel5.setVisible(false);
                    jSpinner2.setVisible(false);
                    jSlider2.setVisible(false);
                }
                InfoDisplayer.this.displayer.pack();
                InfoDisplayer.this.innerGraphPanel.repaint();
            }
        });
        jComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoDisplayer.this.innerGraphPanel.repaint();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    InfoDisplayer.this.autoBot.automate(InfoDisplayer.this.obtainer.obtainStartPos(1), InfoDisplayer.this.obtainer.obtainEndPos(1), InfoDisplayer.this.obtainer.obtainDuration(1), InfoDisplayer.this.obtainer.obtainMiscValue1(), InfoDisplayer.this.obtainer.obtainMiscValue2(), InfoDisplayer.this.obtainer.obtainEaseType1(), InfoDisplayer.this.obtainer.obtainEaseType2());
                }
                catch (NumberFormatException numberFormatException) {
                    InfoDisplayer.appendErrorMessage("some of the textfield inputs are invalid.");
                }
                catch (NullPointerException nullPointerException) {
                    InfoDisplayer.appendErrorMessage("some of the textfield inputs are invalid.");
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                jTextField.setText(jTextField2.getText());
                jTextField2.setText(string);
            }
        });
        jButton3.addActionListener(new ActionListener(){
            int buttonClicks = 0;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ++this.buttonClicks;
                if (this.buttonClicks % 2 == 0) {
                    this.buttonClicks = 0;
                    InfoDisplayer.this.innerAnimPanel.setStart(InfoDisplayer.this.innerAnimPanel.getActualPanelEnd());
                    InfoDisplayer.this.innerAnimPanel.setEnd(InfoDisplayer.this.innerAnimPanel.getActualPanelStart());
                } else {
                    InfoDisplayer.this.innerAnimPanel.setStart(InfoDisplayer.this.innerAnimPanel.getActualPanelStart());
                    InfoDisplayer.this.innerAnimPanel.setEnd(InfoDisplayer.this.innerAnimPanel.getActualPanelEnd());
                }
                if (InfoDisplayer.this.innerAnimPanel.isAnimationRunning()) {
                    InfoDisplayer.this.innerAnimPanel.setStart(InfoDisplayer.this.innerAnimPanel.getCurrentX());
                    InfoDisplayer.this.innerAnimPanel.resetTimer();
                } else {
                    InfoDisplayer.this.innerAnimPanel.startTimer();
                }
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoDisplayer.this.innerGraphPanel.resetTransformPoints();
                InfoDisplayer.this.innerGraphPanel.repaint();
            }
        });
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                jSpinner.setValue((double)jSlider.getValue() / 1000.0);
                InfoDisplayer.this.innerGraphPanel.repaint();
            }
        });
        jSlider2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                jSpinner2.setValue((double)jSlider2.getValue() / 1000.0);
                InfoDisplayer.this.innerGraphPanel.repaint();
            }
        });
        jSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)jSpinner.getValue();
                jSlider.setValue((int)Math.round(d * 1000.0));
            }
        });
        jSpinner2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)jSpinner2.getValue();
                jSlider2.setValue((int)Math.round(d * 1000.0));
            }
        });
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoDisplayer.this.autoBot.setZDistToggle(jCheckBox.isSelected());
            }
        });
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoDisplayer.this.innerAnimPanel.setTrailsToggle(jCheckBox2.isSelected());
            }
        });
        this.innerGraphPanel.addMouseMotionListener(this.innerGraphPanel);
        this.innerGraphPanel.addMouseListener(this.innerGraphPanel);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(Box.createVerticalStrut(5));
        jPanel4.add(jComboBox);
        jPanel4.add(Box.createVerticalStrut(5));
        jPanel4.add(jComboBox2);
        jPanel4.add(Box.createVerticalStrut(5));
        jComboBox.setAlignmentX(0.0f);
        jComboBox2.setAlignmentX(0.0f);
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(Box.createVerticalStrut(5));
        jPanel5.add(jButton2);
        jPanel5.add(Box.createVerticalStrut(5));
        jPanel5.add(jButton);
        jPanel5.add(Box.createVerticalStrut(5));
        jPanel5.add(jButton3);
        jPanel5.add(Box.createVerticalStrut(5));
        jPanel5.add(jButton4);
        jPanel5.add(Box.createVerticalStrut(5));
        jPanel5.add(Box.createVerticalGlue());
        jButton2.setAlignmentX(0.0f);
        jButton.setAlignmentX(0.0f);
        jButton3.setAlignmentX(0.0f);
        jButton4.setAlignmentX(0.0f);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add(Box.createHorizontalStrut(5), "Before");
        jPanel3.add((Component)this.innerGraphPanel, "Center");
        jPanel3.add(Box.createHorizontalStrut(5), "After");
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.innerAnimPanel, "Center");
        GroupLayout groupLayout2 = new GroupLayout(jPanel6);
        jPanel6.setLayout(groupLayout2);
        groupLayout2.setAutoCreateGaps(true);
        groupLayout2.setAutoCreateContainerGaps(true);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 1));
        jPanel9.add(Box.createVerticalStrut(5));
        jPanel9.add(jLabel);
        jPanel9.add(Box.createVerticalStrut(5));
        jPanel9.add(jTextField);
        jPanel9.add(Box.createVerticalStrut(5));
        jPanel9.add(jLabel2);
        jPanel9.add(Box.createVerticalStrut(5));
        jPanel9.add(jTextField2);
        jPanel9.add(Box.createVerticalStrut(5));
        jPanel9.add(jLabel3);
        jPanel9.add(Box.createVerticalStrut(5));
        jPanel9.add(jTextField3);
        jPanel9.add(Box.createVerticalGlue());
        jLabel.setAlignmentX(0.0f);
        jTextField.setAlignmentX(0.0f);
        jLabel2.setAlignmentX(0.0f);
        jTextField2.setAlignmentX(0.0f);
        jLabel3.setAlignmentX(0.0f);
        jTextField3.setAlignmentX(0.0f);
        JPanel jPanel10 = new JPanel();
        jPanel10.add(jLabel4);
        jPanel10.add(jSpinner);
        jPanel10.setMaximumSize(new Dimension(Integer.MAX_VALUE, jPanel10.getPreferredSize().height));
        JPanel jPanel11 = new JPanel();
        jPanel11.add(jLabel5);
        jPanel11.add(jSpinner2);
        jPanel11.setMaximumSize(new Dimension(Integer.MAX_VALUE, jPanel11.getPreferredSize().height));
        Component component = Box.createVerticalStrut(15);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BoxLayout(jPanel12, 1));
        jPanel12.add(jPanel10);
        jPanel12.add(jSlider);
        jPanel12.add(jPanel11);
        jPanel12.add(jSlider2);
        jPanel12.add(component);
        jPanel12.add(jCheckBox);
        jPanel12.add(jCheckBox2);
        jPanel12.add(Box.createVerticalGlue());
        jPanel10.setAlignmentX(0.0f);
        jSlider.setAlignmentX(0.0f);
        jPanel11.setAlignmentX(0.0f);
        jSlider2.setAlignmentX(0.0f);
        jCheckBox.setAlignmentX(0.0f);
        jCheckBox2.setAlignmentX(0.0f);
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.add(currentCoordLabel);
        jPanel7.add(this.firstCoordLabel);
        jPanel7.add(this.secondCoordLabel);
        currentCoordLabel.setAlignmentX(0.5f);
        this.firstCoordLabel.setAlignmentX(0.5f);
        this.secondCoordLabel.setAlignmentX(0.5f);
        jPanel8.add(Box.createVerticalStrut(0));
        jPanel8.add(jPanel7);
        jPanel8.add(Box.createVerticalStrut(0));
        Component component2 = Box.createHorizontalGlue();
        groupLayout2.setHorizontalGroup(groupLayout2.createSequentialGroup().addComponent(jPanel9).addComponent(jPanel12).addComponent(component2));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel9).addComponent(jPanel12).addComponent(component2));
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jPanel2).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel4).addComponent(jPanel5)).addComponent(jPanel6)).addComponent(jPanel3).addComponent(jPanel8));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(jPanel2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(jPanel4).addComponent(jPanel5)).addComponent(jPanel6)).addComponent(jPanel3).addComponent(jPanel8));
        JPanel jPanel13 = new JPanel();
        errorLogArea = new JTextArea(10, 10);
        errorLogArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(errorLogArea);
        jPanel13.setLayout(new BorderLayout());
        jPanel13.add(Box.createRigidArea(new Dimension(10, 10)), "Before");
        jPanel13.add(Box.createRigidArea(new Dimension(10, 10)), "After");
        jPanel13.add(Box.createRigidArea(new Dimension(10, 10)), "First");
        jPanel13.add(Box.createRigidArea(new Dimension(10, 10)), "Last");
        jPanel13.add((Component)jScrollPane, "Center");
        errorLogArea.setMaximumSize(errorLogArea.getPreferredSize());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("User Interface", jPanel);
        jTabbedPane.addTab("Error Log", jPanel13);
        Container container = this.getContentPane();
        container.add(Box.createRigidArea(new Dimension(10, 10)), "Before");
        container.add(Box.createRigidArea(new Dimension(10, 10)), "After");
        container.add(Box.createRigidArea(new Dimension(10, 10)), "First");
        container.add(Box.createRigidArea(new Dimension(10, 10)), "Last");
        container.add((Component)jTabbedPane, "Center");
        jLabel5.setVisible(false);
        jSpinner2.setVisible(false);
        jSlider2.setVisible(false);
        this.pack();
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setVisible(true);
        MouseCoordTracker mouseCoordTracker = new MouseCoordTracker();
        mouseCoordTracker.start();
    }

    public static void appendErrorMessage(String string) {
        errorLogArea.append("Action occured at " + InfoDisplayer.getCurrentTime());
        errorLogArea.append(System.lineSeparator());
        errorLogArea.append("(" + string + ")");
        errorLogArea.append(System.lineSeparator());
        errorLogArea.append(System.lineSeparator());
    }

    public static String getCurrentTime() {
        Object object;
        Object object2;
        Object object3;
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(10);
        if (n == 0) {
            n = 12;
        }
        if (((String)(object3 = String.valueOf(n))).length() == 1) {
            object3 = "0" + (String)object3;
        }
        if (((String)(object2 = String.valueOf(calendar.get(12)))).length() == 1) {
            object2 = "0" + (String)object2;
        }
        if (((String)(object = String.valueOf(calendar.get(13)))).length() == 1) {
            object = "0" + (String)object;
        }
        String string = String.valueOf(calendar.get(14));
        String string2 = (String)object3 + ":" + (String)object2 + ":" + (String)object + "." + string;
        return string2;
    }

    public void applyKeystroke(JPanel jPanel) {
        jPanel.getInputMap(2).put(KeyStroke.getKeyStroke(49, 128), "coord1");
        jPanel.getActionMap().put("coord1", new Coord1Tracker());
        jPanel.getInputMap(2).put(KeyStroke.getKeyStroke(50, 128), "coord2");
        jPanel.getActionMap().put("coord2", new Coord2Tracker());
    }

    public static double returnValidDouble(String string) throws NumberFormatException, NullPointerException {
        double d = Double.parseDouble(string);
        return d;
    }

    class InnerAnimationPanel
    extends JPanel
    implements ActionListener {
        boolean trailsEnabled;
        int trailAmount = 20;
        ArrayList<Integer> trailCoordList = new ArrayList();
        Color[] colorList = new Color[this.trailAmount];
        int origSquareSize = 72;
        int elapsedTime;
        int startX;
        int endX;
        int rectXPos;
        Timer animationTimer;

        public InnerAnimationPanel() {
            this.setupAlpha();
            this.setupTimer();
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.origSquareSize));
        }

        public void setupAlpha() {
            for (int i = 0; i < this.trailAmount; ++i) {
                float f = (float)(0.5 - 0.5 * (double)i / (double)this.trailAmount);
                this.colorList[i] = new Color(1.0f, 0.0f, 0.0f, f);
            }
        }

        public void setupTimer() {
            this.animationTimer = new Timer(10, this);
        }

        public void startTimer() {
            this.animationTimer.start();
        }

        public void stopTimer() {
            this.elapsedTime = 0;
            this.animationTimer.stop();
        }

        public void resetTimer() {
            this.elapsedTime = 0;
            this.animationTimer.restart();
        }

        public int getActualPanelEnd() {
            return this.getWidth() - this.origSquareSize;
        }

        public int getActualPanelStart() {
            return 0;
        }

        public int getStart() {
            return this.startX;
        }

        public int getEnd() {
            return this.endX;
        }

        public void setStart(int n) {
            this.startX = n;
        }

        public void setEnd(int n) {
            this.endX = n;
        }

        public int getCurrentX() {
            return this.rectXPos;
        }

        public void setTrailsToggle(boolean bl) {
            this.trailsEnabled = bl;
        }

        public boolean isAnimationRunning() {
            return this.animationTimer.isRunning();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(Color.RED);
            graphics.fillRect(this.rectXPos + this.origSquareSize / 6, this.origSquareSize / 6, this.origSquareSize * 2 / 3, this.origSquareSize * 2 / 3);
            if (this.trailsEnabled) {
                for (int i = 0; i < this.trailCoordList.size(); ++i) {
                    if (this.trailCoordList.get(i) == Integer.MAX_VALUE) continue;
                    graphics.setColor(this.colorList[i]);
                    graphics.fillRect(this.trailCoordList.get(i) + this.origSquareSize / 6, this.origSquareSize / 6, this.origSquareSize * 2 / 3, this.origSquareSize * 2 / 3);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            this.elapsedTime += 10;
            try {
                if ((double)this.elapsedTime > InfoDisplayer.this.obtainer.obtainDuration(2)) {
                    this.rectXPos = this.getEnd();
                    bl = true;
                } else {
                    this.rectXPos = (int)Math.round(EaseEquations.returnValidEasing(InfoDisplayer.this.obtainer.obtainStartPos(2), InfoDisplayer.this.obtainer.obtainEndPos(2), InfoDisplayer.this.obtainer.obtainDuration(2), InfoDisplayer.this.obtainer.obtainMiscValue1(), InfoDisplayer.this.obtainer.obtainMiscValue2(), InfoDisplayer.this.obtainer.obtainEaseType1(), InfoDisplayer.this.obtainer.obtainEaseType2(), this.elapsedTime));
                }
            }
            catch (NumberFormatException numberFormatException) {
                InfoDisplayer.appendErrorMessage("your input for the duration textfield isn't valid.");
                this.stopTimer();
                return;
            }
            catch (NullPointerException nullPointerException) {
                InfoDisplayer.appendErrorMessage("your input for the duration textfield isn't valid.");
                this.stopTimer();
                return;
            }
            if (!bl) {
                this.trailCoordList.add(0, this.rectXPos);
            } else {
                this.trailCoordList.add(0, Integer.MAX_VALUE);
            }
            if (this.trailCoordList.size() > this.trailAmount) {
                this.trailCoordList.remove(this.trailCoordList.size() - 1);
            }
            if (this.checkIfIntegerMax()) {
                this.stopTimer();
            }
            this.repaint();
        }

        public boolean checkIfIntegerMax() {
            for (int i = 0; i < this.trailCoordList.size(); ++i) {
                if (this.trailCoordList.get(i) == Integer.MAX_VALUE) continue;
                return false;
            }
            return true;
        }
    }

    class InnerGraphPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        int startOffset = 10;
        int graphOffsetX;
        int graphOffsetY;
        int lastTransformX;
        int lastTransformY;
        int initialClickX;
        int initialClickY;

        public InnerGraphPanel() {
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, 150));
            this.setBackground(Color.WHITE);
        }

        public int returnStart() {
            return this.getHeight() - this.startOffset - 1;
        }

        public int returnEnd() {
            return this.startOffset;
        }

        public int returnLengthWithOffset() {
            return this.getWidth() - 2 * this.startOffset;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.translate(this.graphOffsetX, this.graphOffsetY);
            int n = this.returnStart();
            int n2 = this.returnEnd();
            int n3 = this.returnLengthWithOffset();
            int n4 = 0;
            int n5 = 0;
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(this.startOffset, n);
            graphics2D.rotate(Math.toRadians(45.0));
            graphics2D.drawLine(0, -this.startOffset / 2, 0, this.startOffset / 2);
            graphics2D.rotate(Math.toRadians(-90.0));
            graphics2D.drawLine(0, -this.startOffset / 2, 0, this.startOffset / 2);
            graphics2D.setTransform(affineTransform);
            graphics2D.translate(this.getWidth() - this.startOffset - 1, n2);
            graphics2D.rotate(Math.toRadians(45.0));
            graphics2D.drawLine(0, -this.startOffset / 2, 0, this.startOffset / 2);
            graphics2D.rotate(Math.toRadians(-90.0));
            graphics2D.drawLine(0, -this.startOffset / 2, 0, this.startOffset / 2);
            graphics2D.setTransform(affineTransform);
            for (int i = 0; i < n3; i += 2) {
                n4 = (int)Math.round(EaseEquations.returnValidEasing(InfoDisplayer.this.obtainer.obtainStartPos(3), InfoDisplayer.this.obtainer.obtainEndPos(3), InfoDisplayer.this.obtainer.obtainDuration(3), InfoDisplayer.this.obtainer.obtainMiscValue1(), InfoDisplayer.this.obtainer.obtainMiscValue2(), InfoDisplayer.this.obtainer.obtainEaseType1(), InfoDisplayer.this.obtainer.obtainEaseType2(), i));
                if (i < n3) {
                    n5 = (int)Math.round(EaseEquations.returnValidEasing(InfoDisplayer.this.obtainer.obtainStartPos(3), InfoDisplayer.this.obtainer.obtainEndPos(3), InfoDisplayer.this.obtainer.obtainDuration(3), InfoDisplayer.this.obtainer.obtainMiscValue1(), InfoDisplayer.this.obtainer.obtainMiscValue2(), InfoDisplayer.this.obtainer.obtainEaseType1(), InfoDisplayer.this.obtainer.obtainEaseType2(), i + 2));
                    graphics2D.drawLine(this.startOffset + i - 1, n4, this.startOffset + i + 1, n5);
                    continue;
                }
                n5 = n2;
                graphics2D.drawLine(this.startOffset + i - 1, n4, this.startOffset + n3 - 2, n5);
            }
            Font font = new Font("Arial", 0, 12);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString("Made by StickActions", this.startOffset, this.getHeight() + (int)fontMetrics.getLineMetrics("A", graphics2D).getHeight());
            graphics2D.drawString("(A.K.A Kcits)", this.startOffset, this.getHeight() + 2 * (int)fontMetrics.getLineMetrics("A", graphics2D).getHeight());
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.initialClickX = mouseEvent.getX();
            this.initialClickY = mouseEvent.getY();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.graphOffsetX = this.lastTransformX + mouseEvent.getX() - this.initialClickX;
            this.graphOffsetY = this.lastTransformY + mouseEvent.getY() - this.initialClickY;
            this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.lastTransformX = this.graphOffsetX;
            this.lastTransformY = this.graphOffsetY;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void resetTransformPoints() {
            this.graphOffsetX = 0;
            this.graphOffsetY = 0;
            this.lastTransformX = 0;
            this.lastTransformY = 0;
        }
    }

    class Coord1Tracker
    extends AbstractAction {
        Coord1Tracker() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            coord1X = currentMouseCoordX;
            coord1Y = currentMouseCoordY;
            InfoDisplayer.this.firstCoordLabel.setText("Coordinate 1: (" + String.valueOf(coord1X) + ", " + String.valueOf(coord1Y) + ")");
        }
    }

    class Coord2Tracker
    extends AbstractAction {
        Coord2Tracker() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            coord2X = currentMouseCoordX;
            coord2Y = currentMouseCoordY;
            InfoDisplayer.this.secondCoordLabel.setText("Coordinate 2: (" + String.valueOf(coord2X) + ", " + String.valueOf(coord2Y) + ")");
        }
    }
}

